/*
 * Decompiled with CFR 0.152.
 */
package com.banall;

import com.banall.command.BanCommand;
import com.banall.command.UnbanCommand;
import com.banall.config.ConfigManager;
import com.banall.network.ModCheckPacket;
import com.banall.server.BanManager;
import com.banall.server.MachineCodeStorage;
import com.banall.server.UdpServerManager;
import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanAllMod
implements ModInitializer {
    public static final String MOD_ID = "ban-all";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ban-all");
    private static BanManager banManager;
    private static UdpServerManager udpServer;

    public void onInitialize() {
        LOGGER.info("BanAll Mod \u6b63\u5728\u521d\u59cb\u5316...");
        ConfigManager configManager = ConfigManager.getInstance();
        ConfigManager.ConfigData config = configManager.getConfig();
        MachineCodeStorage.loadStorage();
        banManager = new BanManager();
        udpServer = new UdpServerManager(banManager);
        udpServer.start(config.httpServerPort, config.httpServerHost);
        LOGGER.info("UDP\u670d\u52a1\u5668\u5df2\u542f\u52a8: {}:{}", (Object)config.httpServerHost, (Object)config.httpServerPort);
        ModCheckPacket.register();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> udpServer.setMinecraftServer(server));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            new BanCommand(banManager).register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            new UnbanCommand(banManager).register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (udpServer != null) {
                udpServer.stop();
            }
        });
        LOGGER.info("BanAll Mod \u521d\u59cb\u5316\u5b8c\u6210\uff01");
    }

    public static BanManager getBanManager() {
        return banManager;
    }
}

