/*
 * Decompiled with CFR 0.152.
 */
package com.banall.client;

import com.banall.client.ModCheckClient;
import com.banall.hardware.HardwareCollectorFactory;
import com.banall.hardware.HardwareInfoCollector;
import com.banall.hardware.MachineCodeGenerator;
import com.banall.network.MachineCodeUploader;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class BanAllClientMod
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ban-all-client");
    private static String cachedMachineCode;
    private final MachineCodeUploader uploader = new MachineCodeUploader();

    public void onInitializeClient() {
        LOGGER.info("BanAll Client Mod \u6b63\u5728\u521d\u59cb\u5316...");
        ModCheckClient.register();
        cachedMachineCode = this.generateMachineCode();
        LOGGER.info("\u673a\u5668\u7801\u5df2\u751f\u6210: " + cachedMachineCode);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (cachedMachineCode != null && client.field_1724 != null) {
                String playerName = client.field_1724.method_5477().getString();
                new Thread(() -> {
                    boolean success = this.uploader.uploadMachineCode(cachedMachineCode, playerName);
                    if (success) {
                        LOGGER.info("\u673a\u5668\u7801\u4e0a\u4f20\u6210\u529f (\u73a9\u5bb6: " + playerName + ")");
                    } else {
                        LOGGER.warn("\u673a\u5668\u7801\u4e0a\u4f20\u5931\u8d25");
                    }
                    MachineCodeUploader.BanInfo banInfo = this.uploader.checkBanStatus(cachedMachineCode);
                    if (banInfo != null && banInfo.banned) {
                        client.execute(() -> {
                            if (client.field_1724 != null && client.method_1562() != null) {
                                client.method_1562().method_48296().method_10747((class_2561)class_2561.method_43470((String)("\u4f60\u56e0\u4e3a " + banInfo.reason + " \u88ab\u5c01\u7981")));
                            }
                        });
                    }
                }).start();
            }
        });
        LOGGER.info("BanAll Client Mod \u521d\u59cb\u5316\u5b8c\u6210\uff01");
    }

    private String generateMachineCode() {
        try {
            HardwareInfoCollector collector = HardwareCollectorFactory.create();
            MachineCodeGenerator generator = new MachineCodeGenerator(collector);
            return generator.generate();
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u673a\u5668\u7801\u5931\u8d25: " + e.getMessage(), (Throwable)e);
            return "ERROR-GENERATING-MACHINE-CODE";
        }
    }

    public static String getMachineCode() {
        return cachedMachineCode;
    }
}

