/*
 * Decompiled with CFR 0.152.
 */
package com.banall.command;

import com.banall.server.BanManager;
import com.banall.server.MachineCodeStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class BanCommand {
    private final BanManager banManager;

    public BanCommand(BanManager banManager) {
        this.banManager = banManager;
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kban").requires(source -> source.method_9259(4))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> this.executeBan((CommandContext<class_2168>)context, "\u672a\u6307\u5b9a\u539f\u56e0"))).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(this::executeBan))));
    }

    private int executeBan(CommandContext<class_2168> context, String defaultReason) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9211().method_3760().method_14566(playerName);
        if (player == null) {
            source.method_9226(() -> class_2561.method_43470((String)("\u73a9\u5bb6 " + playerName + " \u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728")), false);
            return 0;
        }
        UUID playerUuid = player.method_5667();
        String machineCode = MachineCodeStorage.getMachineCode(playerUuid);
        if (machineCode == null) {
            machineCode = MachineCodeStorage.getMachineCodeByPlayerName(playerName);
        }
        if (machineCode == null) {
            source.method_9226(() -> class_2561.method_43470((String)("\u65e0\u6cd5\u83b7\u53d6\u73a9\u5bb6 " + playerName + " \u7684\u673a\u5668\u7801\uff0c\u53ef\u80fd\u5c1a\u672a\u4e0a\u4f20")), false);
            return 0;
        }
        this.banManager.banPlayer(machineCode, defaultReason);
        player.field_13987.method_52396((class_2561)class_2561.method_43470((String)("\u4f60\u56e0\u4e3a " + defaultReason + " \u88ab\u5c01\u7981")));
        source.method_9226(() -> class_2561.method_43470((String)("\u5df2\u5c01\u7981\u73a9\u5bb6 " + playerName + "\uff0c\u539f\u56e0: " + defaultReason)), true);
        return 1;
    }

    private int executeBan(CommandContext<class_2168> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        String reason = StringArgumentType.getString(context, (String)"reason");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9211().method_3760().method_14566(playerName);
        if (player == null) {
            source.method_9226(() -> class_2561.method_43470((String)("\u73a9\u5bb6 " + playerName + " \u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728")), false);
            return 0;
        }
        UUID playerUuid = player.method_5667();
        String machineCode = MachineCodeStorage.getMachineCode(playerUuid);
        if (machineCode == null) {
            machineCode = MachineCodeStorage.getMachineCodeByPlayerName(playerName);
        }
        if (machineCode == null) {
            source.method_9226(() -> class_2561.method_43470((String)("\u65e0\u6cd5\u83b7\u53d6\u73a9\u5bb6 " + playerName + " \u7684\u673a\u5668\u7801\uff0c\u53ef\u80fd\u5c1a\u672a\u4e0a\u4f20")), false);
            return 0;
        }
        this.banManager.banPlayer(machineCode, reason);
        player.field_13987.method_52396((class_2561)class_2561.method_43470((String)("\u4f60\u56e0\u4e3a " + reason + " \u88ab\u5c01\u7981")));
        source.method_9226(() -> class_2561.method_43470((String)("\u5df2\u5c01\u7981\u73a9\u5bb6 " + playerName + "\uff0c\u539f\u56e0: " + reason)), true);
        return 1;
    }
}

