/*
 * Decompiled with CFR 0.152.
 */
package com.banall.command;

import com.banall.server.BanManager;
import com.banall.server.MachineCodeStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class UnbanCommand {
    private final BanManager banManager;

    public UnbanCommand(BanManager banManager) {
        this.banManager = banManager;
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unkban").requires(source -> source.method_9259(4))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).executes(this::executeUnban)));
    }

    private int executeUnban(CommandContext<class_2168> context) {
        BanManager.BanEntry partialMatch;
        String playerName = StringArgumentType.getString(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9211().method_3760().method_14566(playerName);
        String machineCode = null;
        if (player != null) {
            UUID playerUuid = player.method_5667();
            machineCode = MachineCodeStorage.getMachineCode(playerUuid);
        }
        if (machineCode == null) {
            machineCode = MachineCodeStorage.getMachineCodeByPlayerName(playerName);
        }
        if (machineCode == null) {
            source.method_9226(() -> class_2561.method_43470((String)("\u65e0\u6cd5\u83b7\u53d6\u73a9\u5bb6 " + playerName + " \u7684\u673a\u5668\u7801\uff0c\u53ef\u80fd\u5c1a\u672a\u4e0a\u4f20\u6216\u73a9\u5bb6\u4e0d\u5b58\u5728")), false);
            return 0;
        }
        boolean isBanned = this.banManager.isBanned(machineCode);
        if (!isBanned && (partialMatch = this.banManager.checkPartialMatch(machineCode)) == null) {
            source.method_9226(() -> class_2561.method_43470((String)("\u73a9\u5bb6 " + playerName + " \u672a\u88ab\u5c01\u7981")), false);
            return 0;
        }
        String finalMachineCode = machineCode;
        boolean success = this.banManager.unbanByMachineCode(finalMachineCode);
        if (success) {
            UUID playerUuid = null;
            if (player != null) {
                playerUuid = player.method_5667();
            }
            if (playerUuid != null) {
                Set<String> allCodes = MachineCodeStorage.getAllMachineCodes(playerUuid);
                for (String code : allCodes) {
                    this.banManager.unbanByMachineCode(code);
                }
                MachineCodeStorage.clearMachineCodeHistory(playerUuid, finalMachineCode);
            } else {
                MachineCodeStorage.clearMachineCodeHistoryByPlayerName(playerName, finalMachineCode);
            }
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("\u89e3\u5c01\u5931\u8d25\uff1a\u672a\u627e\u5230\u73a9\u5bb6 " + playerName + " \u7684\u5c01\u7981\u8bb0\u5f55")), false);
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)("\u5df2\u89e3\u5c01\u73a9\u5bb6 " + playerName + " (\u673a\u5668\u7801: " + finalMachineCode + ")\uff0c\u5df2\u6e05\u7406\u673a\u5668\u7801\u5386\u53f2\u8bb0\u5f55")), true);
        return 1;
    }
}

