/*
 * Decompiled with CFR 0.152.
 */
package com.banall.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final String CONFIG_FILE_NAME = "ban-all.json";
    private static ConfigManager instance;
    private ConfigData config;

    private ConfigManager() {
        this.loadConfig();
    }

    public static ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    private void loadConfig() {
        Path configPath = this.getConfigPath();
        try {
            if (Files.exists(configPath, new LinkOption[0])) {
                String json = new String(Files.readAllBytes(configPath));
                JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
                this.config = (ConfigData)new Gson().fromJson((JsonElement)jsonObject, ConfigData.class);
            } else {
                this.config = new ConfigData();
                this.saveConfig();
            }
        }
        catch (Exception e) {
            System.err.println("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e: " + e.getMessage());
            this.config = new ConfigData();
        }
    }

    public void saveConfig() {
        try {
            Path configPath = this.getConfigPath();
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Gson gson = new Gson();
            String json = gson.toJson((Object)this.config);
            Files.write(configPath, json.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            System.err.println("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
        }
    }

    private Path getConfigPath() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        return configDir.resolve(CONFIG_FILE_NAME);
    }

    public ConfigData getConfig() {
        return this.config;
    }

    public static class ConfigData {
        public String apiServerUrl = "https://ban.wtyxtnt.cn/api/machine-code";
        public int httpServerPort = 8080;
        public String httpServerHost = "127.0.0.1";
        public String phpBackendUrl = "https://ban.wtyxtnt.cn/api/machine-code";
        public boolean usePhpBackend = false;
    }
}

