/*
 * Decompiled with CFR 0.152.
 */
package com.banall.hardware;

import com.banall.hardware.HardwareInfoCollector;
import com.banall.hardware.LinuxCollector;
import com.banall.hardware.MacCollector;
import com.banall.hardware.PlatformDetector;
import com.banall.hardware.WindowsCollector;

public class HardwareCollectorFactory {
    public static HardwareInfoCollector create() {
        if (PlatformDetector.isWindows()) {
            return new WindowsCollector();
        }
        if (PlatformDetector.isMac()) {
            return new MacCollector();
        }
        if (PlatformDetector.isLinux()) {
            return new LinuxCollector();
        }
        return new FallbackCollector();
    }

    private static class FallbackCollector
    implements HardwareInfoCollector {
        private FallbackCollector() {
        }

        @Override
        public String getMotherboardSerial() {
            return "";
        }

        @Override
        public String getSystemUUID() {
            return System.getProperty("java.vm.name", "");
        }

        @Override
        public String getCpuInfo() {
            return System.getProperty("os.arch", "");
        }

        @Override
        public String getDiskSerial() {
            return "";
        }

        @Override
        public String getMacAddress() {
            return "";
        }

        @Override
        public String getBiosInfo() {
            return "";
        }

        @Override
        public String getPlatform() {
            return "Unknown";
        }

        @Override
        public String getSystemFingerprint() {
            return System.getProperty("user.name", "") + "|" + System.getProperty("user.home", "");
        }
    }
}

