/*
 * Decompiled with CFR 0.152.
 */
package com.banall.hardware;

import com.banall.hardware.HardwareInfoCollector;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class LinuxCollector
implements HardwareInfoCollector {
    @Override
    public String getMotherboardSerial() {
        return this.readFile("/sys/class/dmi/id/board_serial");
    }

    @Override
    public String getSystemUUID() {
        return this.readFile("/sys/class/dmi/id/product_uuid");
    }

    @Override
    public String getCpuInfo() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("/proc/cpuinfo"));
            StringBuilder cpuInfo = new StringBuilder();
            int coreCount = 0;
            String modelName = "";
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("processor")) {
                    ++coreCount;
                }
                if (!line.startsWith("model name") || !modelName.isEmpty()) continue;
                modelName = line.split(":")[1].trim();
            }
            reader.close();
            return this.normalize(modelName + "|" + coreCount);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getDiskSerial() {
        return this.executeCommand("lsblk -o SERIAL -n -d | head -1");
    }

    @Override
    public String getMacAddress() {
        return this.executeCommand("ip link show | grep -m1 'link/ether' | awk '{print $2}'");
    }

    @Override
    public String getBiosInfo() {
        String version = this.readFile("/sys/class/dmi/id/bios_version");
        String date = this.readFile("/sys/class/dmi/id/bios_date");
        String vendor = this.readFile("/sys/class/dmi/id/bios_vendor");
        return this.normalize(version + "|" + date + "|" + vendor);
    }

    @Override
    public String getPlatform() {
        return "Linux";
    }

    @Override
    public String getSystemFingerprint() {
        String username = System.getProperty("user.name", "");
        String hostname = this.readFile("/etc/hostname");
        if (hostname.isEmpty()) {
            hostname = System.getenv("HOSTNAME");
        }
        return this.normalize(username + "|" + (hostname != null ? hostname : ""));
    }

    private String readFile(String path) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(path));
            String line = reader.readLine();
            reader.close();
            return this.normalize(line != null ? line : "");
        }
        catch (Exception e) {
            return "";
        }
    }

    private String executeCommand(String command) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", command});
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            String line = reader.readLine();
            process.waitFor();
            return this.normalize(line != null ? line : "");
        }
        catch (Exception e) {
            return "";
        }
    }

    private String normalize(String input) {
        if (input == null || input.trim().isEmpty()) {
            return "";
        }
        return input.trim().replaceAll("\\s+", " ").toUpperCase();
    }
}

