/*
 * Decompiled with CFR 0.152.
 */
package com.banall.hardware;

import com.banall.hardware.HardwareInfoCollector;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class MacCollector
implements HardwareInfoCollector {
    @Override
    public String getMotherboardSerial() {
        return this.executeCommand("system_profiler SPHardwareDataType | grep 'Serial Number' | awk '{print $4}'");
    }

    @Override
    public String getSystemUUID() {
        return this.executeCommand("ioreg -rd1 -c IOPlatformExpertDevice | grep -E '(UUID)' | head -1 | awk '{print $3}' | tr -d '\"'");
    }

    @Override
    public String getCpuInfo() {
        String brand = this.executeCommand("sysctl -n machdep.cpu.brand_string");
        String cores = this.executeCommand("sysctl -n hw.ncpu");
        String freq = this.executeCommand("sysctl -n hw.cpufrequency");
        return this.normalize(brand + "|" + cores + "|" + freq);
    }

    @Override
    public String getDiskSerial() {
        return this.executeCommand("diskutil info / | grep 'Volume UUID' | awk '{print $3}'");
    }

    @Override
    public String getMacAddress() {
        return this.executeCommand("ifconfig en0 | grep ether | awk '{print $2}'");
    }

    @Override
    public String getBiosInfo() {
        String version = this.executeCommand("system_profiler SPHardwareDataType | grep 'Boot ROM Version' | awk '{print $4}'");
        String smc = this.executeCommand("system_profiler SPHardwareDataType | grep 'SMC Version' | awk '{print $4}'");
        return this.normalize(version + "|" + smc);
    }

    @Override
    public String getPlatform() {
        return "macOS";
    }

    @Override
    public String getSystemFingerprint() {
        String username = System.getProperty("user.name", "");
        String hostname = this.executeCommand("scutil --get ComputerName");
        return this.normalize(username + "|" + hostname);
    }

    private String executeCommand(String command) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", command});
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            String line = reader.readLine();
            process.waitFor();
            return this.normalize(line != null ? line : "");
        }
        catch (Exception e) {
            return "";
        }
    }

    private String normalize(String input) {
        if (input == null || input.trim().isEmpty()) {
            return "";
        }
        return input.trim().replaceAll("\\s+", " ").toUpperCase();
    }
}

