/*
 * Decompiled with CFR 0.152.
 */
package com.banall.hardware;

import com.banall.hardware.HardwareInfoCollector;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class MachineCodeGenerator {
    private static final String SALT = "BAN_ALL_SALT_2024_SECURE";
    private static final String CHARS = "ABCDEFGHJKLMNPQRSTUVWXYZ23456789";
    private final HardwareInfoCollector collector;

    public MachineCodeGenerator(HardwareInfoCollector collector) {
        this.collector = collector;
    }

    public String generate() {
        try {
            Map<String, String> rawData = this.collectAllInfo();
            String segment1 = this.generateSegment(rawData.get("motherboard"), "motherboard");
            String segment2 = this.generateSegment(rawData.get("uuid"), "uuid");
            String segment3 = this.generateSegment(rawData.get("cpu"), "cpu");
            String segment4 = this.generateSegment(rawData.get("disk"), "disk");
            String segment5 = this.generateSegment(rawData.get("mac"), "mac");
            return segment1 + "-" + segment2 + "-" + segment3 + "-" + segment4 + "-" + segment5;
        }
        catch (Exception e) {
            return this.generateFallback();
        }
    }

    private String generateSegment(String hardwareInfo, String type) {
        if (hardwareInfo == null || ((String)hardwareInfo).isEmpty()) {
            hardwareInfo = "UNKNOWN_" + type;
        }
        try {
            String salted = (String)hardwareInfo + "|BAN_ALL_SALT_2024_SECURE|" + type;
            String hash = this.sha256(salted);
            return this.formatSegment(hash);
        }
        catch (Exception e) {
            return "ERROR";
        }
    }

    private String formatSegment(String hash) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            int index = (hash.charAt(i % hash.length()) + i) % CHARS.length();
            result.append(CHARS.charAt(index));
        }
        return result.toString();
    }

    private Map<String, String> collectAllInfo() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("motherboard", this.collector.getMotherboardSerial());
        data.put("uuid", this.collector.getSystemUUID());
        data.put("cpu", this.collector.getCpuInfo());
        data.put("disk", this.collector.getDiskSerial());
        data.put("mac", this.collector.getMacAddress());
        data.put("bios", this.collector.getBiosInfo());
        data.put("fingerprint", this.collector.getSystemFingerprint());
        data.put("platform", this.collector.getPlatform());
        return data;
    }

    private String sha256(String input) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
        return this.bytesToHex(hash);
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString().toUpperCase();
    }

    private String formatMachineCode(String hash) {
        StringBuilder result = new StringBuilder();
        int charIndex = 0;
        for (int i = 0; i < 25; ++i) {
            if (i > 0 && i % 5 == 0) {
                result.append('-');
            }
            int index = (hash.charAt(charIndex % hash.length()) + i) % CHARS.length();
            result.append(CHARS.charAt(index));
            ++charIndex;
        }
        return result.toString();
    }

    private String generateFallback() {
        try {
            String fallback = System.getProperty("user.name", "") + System.getProperty("user.home", "") + System.getProperty("os.name", "") + System.getProperty("os.arch", "");
            String hash = this.sha256(fallback + SALT);
            return this.formatMachineCode(hash);
        }
        catch (Exception e) {
            return "FALLBACK-ERROR-CODE-GENERATION";
        }
    }
}

