/*
 * Decompiled with CFR 0.152.
 */
package com.banall.hardware;

import java.util.Locale;

public class PlatformDetector {
    private static final String OS = System.getProperty("os.name", "unknown").toLowerCase(Locale.ROOT);

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isLinux() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    public static String getPlatform() {
        if (PlatformDetector.isWindows()) {
            return "Windows";
        }
        if (PlatformDetector.isMac()) {
            return "macOS";
        }
        if (PlatformDetector.isLinux()) {
            return "Linux";
        }
        return "Unknown";
    }
}

