/*
 * Decompiled with CFR 0.152.
 */
package com.banall.hardware;

import com.banall.hardware.HardwareInfoCollector;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

public class WindowsCollector
implements HardwareInfoCollector {
    @Override
    public String getMotherboardSerial() {
        return this.executeCommand("wmic baseboard get serialnumber");
    }

    @Override
    public String getSystemUUID() {
        return this.executeCommand("wmic csproduct get uuid");
    }

    @Override
    public String getCpuInfo() {
        String name = this.executeCommand("wmic cpu get name");
        String cores = this.executeCommand("wmic cpu get numberofcores");
        String maxClock = this.executeCommand("wmic cpu get maxclockspeed");
        return this.normalize(name + "|" + cores + "|" + maxClock);
    }

    @Override
    public String getDiskSerial() {
        return this.executeCommand("wmic diskdrive where index=0 get serialnumber");
    }

    @Override
    public String getMacAddress() {
        return this.executeCommand("getmac /fo csv /nh");
    }

    @Override
    public String getBiosInfo() {
        String version = this.executeCommand("wmic bios get version");
        String date = this.executeCommand("wmic bios get releasedate");
        String manufacturer = this.executeCommand("wmic bios get manufacturer");
        return this.normalize(version + "|" + date + "|" + manufacturer);
    }

    @Override
    public String getPlatform() {
        return "Windows";
    }

    @Override
    public String getSystemFingerprint() {
        String username = System.getProperty("user.name", "");
        String hostname = System.getenv("COMPUTERNAME");
        if (hostname == null) {
            hostname = System.getenv("HOSTNAME");
        }
        return this.normalize(username + "|" + (hostname != null ? hostname : ""));
    }

    private String executeCommand(String command) {
        try {
            String line;
            Process process = Runtime.getRuntime().exec("cmd /c " + command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.equalsIgnoreCase("SerialNumber") || line.equalsIgnoreCase("UUID") || line.equalsIgnoreCase("Name") || line.equalsIgnoreCase("NumberOfCores") || line.equalsIgnoreCase("MaxClockSpeed") || line.equalsIgnoreCase("Version") || line.equalsIgnoreCase("ReleaseDate") || line.equalsIgnoreCase("Manufacturer") || Pattern.matches("^[A-Za-z]+\\s*$", line)) continue;
                output.append(line).append(" ");
            }
            process.waitFor();
            return this.normalize(output.toString());
        }
        catch (Exception e) {
            return "";
        }
    }

    private String normalize(String input) {
        if (input == null || input.trim().isEmpty()) {
            return "";
        }
        return input.trim().replaceAll("\\s+", " ").toUpperCase();
    }
}

