/*
 * Decompiled with CFR 0.152.
 */
package com.banall.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;

public class MachineCodeUploader {
    private static final String SERVER_HOST = "ban.wtyxtnt.cn";
    private static final int SERVER_PORT = 8080;
    private final Gson gson = new Gson();

    public boolean uploadMachineCode(String machineCode, String playerName) {
        JsonObject json = new JsonObject();
        json.addProperty("machineCode", machineCode);
        json.addProperty("playerName", playerName);
        json.addProperty("timestamp", (Number)System.currentTimeMillis());
        String jsonData = this.gson.toJson((JsonElement)json);
        byte[] data = jsonData.getBytes(StandardCharsets.UTF_8);
        InetAddress serverAddress = InetAddress.getByName(SERVER_HOST);
        DatagramPacket packet = new DatagramPacket(data, data.length, serverAddress, 8080);
        DatagramSocket socket = new DatagramSocket();
        try {
            socket.setSoTimeout(5000);
            socket.send(packet);
            boolean bl = true;
            socket.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnknownHostException e) {
                System.err.println("Failed to resolve server host: " + e.getMessage());
                return false;
            }
            catch (IOException e) {
                System.err.println("Failed to upload machine code via UDP: " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BanInfo checkBanStatus(String machineCode) {
        try {
            JsonObject json = new JsonObject();
            json.addProperty("action", "check");
            json.addProperty("machineCode", machineCode);
            String jsonData = this.gson.toJson((JsonElement)json);
            byte[] data = jsonData.getBytes(StandardCharsets.UTF_8);
            InetAddress serverAddress = InetAddress.getByName(SERVER_HOST);
            DatagramPacket sendPacket = new DatagramPacket(data, data.length, serverAddress, 8080);
            try (DatagramSocket socket = new DatagramSocket();){
                socket.setSoTimeout(3000);
                socket.send(sendPacket);
                byte[] buffer = new byte[1024];
                DatagramPacket receivePacket = new DatagramPacket(buffer, buffer.length);
                socket.receive(receivePacket);
                String responseJson = new String(receivePacket.getData(), 0, receivePacket.getLength(), StandardCharsets.UTF_8);
                JsonObject obj = (JsonObject)this.gson.fromJson(responseJson, JsonObject.class);
                if (!obj.has("banned")) return null;
                if (!obj.get("banned").getAsBoolean()) return null;
                BanInfo banInfo = new BanInfo();
                banInfo.banned = true;
                banInfo.reason = obj.has("reason") ? obj.get("reason").getAsString() : "\u672a\u77e5\u539f\u56e0";
                banInfo.timestamp = obj.has("timestamp") ? obj.get("timestamp").getAsLong() : 0L;
                BanInfo banInfo2 = banInfo;
                return banInfo2;
            }
        }
        catch (SocketTimeoutException e) {
            System.err.println("Ban check timeout: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            System.err.println("Failed to check ban status via UDP: " + e.getMessage());
        }
        return null;
    }

    public static class BanInfo {
        public boolean banned;
        public String reason;
        public long timestamp;
    }
}

