/*
 * Decompiled with CFR 0.152.
 */
package com.banall.server;

import com.banall.server.MachineCodeStorage;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class BanManager {
    private static final Path BAN_FILE = Paths.get("bans.json", new String[0]);
    private final Map<String, BanEntry> bans = new ConcurrentHashMap<String, BanEntry>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public BanManager() {
        this.loadBans();
        this.registerEvents();
    }

    public void banPlayer(String machineCode, String reason) {
        BanEntry entry = new BanEntry();
        entry.machineCode = machineCode;
        entry.reason = reason;
        entry.timestamp = System.currentTimeMillis();
        entry.bannedBy = "Server";
        this.bans.put(machineCode, entry);
        this.saveBans();
    }

    public void unbanPlayer(String machineCode) {
        this.bans.remove(machineCode);
        this.saveBans();
    }

    public boolean unbanByMachineCode(String machineCode) {
        String[] segments;
        if (machineCode == null || machineCode.isEmpty()) {
            return false;
        }
        boolean removed = false;
        if (this.bans.containsKey(machineCode)) {
            this.bans.remove(machineCode);
            removed = true;
        }
        if ((segments = machineCode.split("-")).length == 5) {
            Iterator<Map.Entry<String, BanEntry>> iterator = this.bans.entrySet().iterator();
            block0: while (iterator.hasNext()) {
                Map.Entry<String, BanEntry> entry = iterator.next();
                String bannedCode = entry.getKey();
                String[] bannedSegments = bannedCode.split("-");
                if (bannedSegments.length != 5) continue;
                for (int i = 0; i < 5; ++i) {
                    if (!segments[i].equals(bannedSegments[i])) continue;
                    iterator.remove();
                    removed = true;
                    continue block0;
                }
            }
        }
        if (removed) {
            this.saveBans();
        }
        return removed;
    }

    public BanEntry getBanEntry(String machineCode) {
        return this.bans.get(machineCode);
    }

    public boolean isBanned(String machineCode) {
        return this.bans.containsKey(machineCode);
    }

    public BanEntry checkPartialMatch(String machineCode) {
        if (machineCode == null || machineCode.isEmpty()) {
            return null;
        }
        String[] segments = machineCode.split("-");
        if (segments.length != 5) {
            return null;
        }
        for (Map.Entry<String, BanEntry> entry : this.bans.entrySet()) {
            String bannedCode = entry.getKey();
            String[] bannedSegments = bannedCode.split("-");
            if (bannedSegments.length != 5) continue;
            for (int i = 0; i < 5; ++i) {
                if (!segments[i].equals(bannedSegments[i])) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private void loadBans() {
        if (!Files.exists(BAN_FILE, new LinkOption[0])) {
            return;
        }
        try {
            String json = new String(Files.readAllBytes(BAN_FILE));
            BanData data = (BanData)this.gson.fromJson(json, BanData.class);
            if (data != null && data.bans != null) {
                this.bans.putAll(data.bans);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load bans: " + e.getMessage());
        }
    }

    private void saveBans() {
        try {
            BanData data = new BanData();
            data.bans = new HashMap<String, BanEntry>(this.bans);
            String json = this.gson.toJson((Object)data);
            Files.write(BAN_FILE, json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save bans: " + e.getMessage());
        }
    }

    private void registerEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            String playerName = player.method_5477().getString();
            UUID playerUuid = player.method_5667();
            String historicalMachineCode = MachineCodeStorage.getMachineCode(playerUuid);
            if (historicalMachineCode == null) {
                historicalMachineCode = MachineCodeStorage.getMachineCodeByPlayerName(playerName);
            }
            if (historicalMachineCode != null && !historicalMachineCode.isEmpty()) {
                BanEntry entry = null;
                entry = this.isBanned(historicalMachineCode) ? this.getBanEntry(historicalMachineCode) : this.checkPartialMatch(historicalMachineCode);
                if (entry != null) {
                    String reason = entry.reason != null ? entry.reason : "\u672a\u77e5\u539f\u56e0";
                    server.execute(() -> {
                        if (player.field_13987 != null) {
                            player.field_13987.method_52396((class_2561)class_2561.method_43470((String)("\u4f60\u56e0\u4e3a " + reason + " \u88ab\u5c01\u7981")));
                        }
                    });
                    return;
                }
            }
            class_3222 finalPlayer = player;
            String finalPlayerName = playerName;
            UUID finalPlayerUuid = playerUuid;
            new Thread(() -> {
                try {
                    for (int i = 0; i < 20; ++i) {
                        Thread.sleep(500L);
                        String finalMachineCode = MachineCodeStorage.getMachineCodeByPlayerName(finalPlayerName);
                        if (finalMachineCode == null) continue;
                        String oldMachineCode = MachineCodeStorage.getMachineCode(finalPlayerUuid);
                        if (oldMachineCode != null && !oldMachineCode.equals(finalMachineCode)) {
                            Set<String> allMachineCodes = MachineCodeStorage.getAllMachineCodes(finalPlayerUuid);
                            allMachineCodes.add(finalMachineCode);
                            allMachineCodes.add(oldMachineCode);
                            String reason = "\u8d26\u6237\u4f7f\u7528\u591a\u4e2a\u673a\u5668\u7801\u767b\u5f55\uff08\u53ef\u80fd\u7981\u7528\u6a21\u7ec4\u6216\u4f7f\u7528\u4e0d\u540c\u8bbe\u5907\uff09";
                            for (String code : allMachineCodes) {
                                if (this.isBanned(code)) continue;
                                this.banPlayer(code, reason);
                            }
                            server.execute(() -> {
                                if (finalPlayer.field_13987 != null) {
                                    finalPlayer.field_13987.method_52396((class_2561)class_2561.method_43470((String)"\u68c0\u6d4b\u5230\u8d26\u6237\u4f7f\u7528\u591a\u4e2a\u673a\u5668\u7801\u767b\u5f55\uff0c\u6240\u6709\u76f8\u5173\u673a\u5668\u7801\u5df2\u88ab\u5c01\u7981"));
                                }
                            });
                            return;
                        }
                        MachineCodeStorage.storeMachineCode(finalPlayerUuid, finalPlayerName, finalMachineCode);
                        BanEntry entry = null;
                        entry = this.isBanned(finalMachineCode) ? this.getBanEntry(finalMachineCode) : this.checkPartialMatch(finalMachineCode);
                        if (entry != null) {
                            String reason = entry.reason != null ? entry.reason : "\u672a\u77e5\u539f\u56e0";
                            server.execute(() -> {
                                if (finalPlayer.field_13987 != null) {
                                    finalPlayer.field_13987.method_52396((class_2561)class_2561.method_43470((String)("\u4f60\u56e0\u4e3a " + reason + " \u88ab\u5c01\u7981")));
                                }
                            });
                        }
                        return;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        });
    }

    public static class BanEntry {
        public String machineCode;
        public String reason;
        public long timestamp;
        public String bannedBy;
    }

    private static class BanData {
        public Map<String, BanEntry> bans;

        private BanData() {
        }
    }
}

