/*
 * Decompiled with CFR 0.152.
 */
package com.banall.server;

import com.banall.network.ModCheckPacket;
import com.banall.server.BanManager;
import com.banall.server.MachineCodeStorage;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class HttpServerManager {
    private HttpServer server;
    private final BanManager banManager;
    private final Gson gson = new Gson();
    private MinecraftServer minecraftServer;

    public HttpServerManager(BanManager banManager) {
        this.banManager = banManager;
    }

    public void setMinecraftServer(MinecraftServer server) {
        this.minecraftServer = server;
    }

    public void start(int port) {
        this.start(port, "0.0.0.0");
    }

    public void start(int port, String host) {
        try {
            InetSocketAddress address = new InetSocketAddress(host, port);
            this.server = HttpServer.create(address, 0);
            this.server.createContext("/api/machine-code", new MachineCodeHandler());
            this.server.createContext("/api/machine-code/check", new CheckBanHandler());
            this.server.setExecutor(null);
            this.server.start();
            System.out.println("HTTP Server started on " + host + ":" + port);
        }
        catch (IOException e) {
            System.err.println("Failed to start HTTP server: " + e.getMessage());
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
        }
    }

    private void sendResponse(HttpExchange exchange, int statusCode, String response) throws IOException {
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=utf-8");
        exchange.sendResponseHeaders(statusCode, response.getBytes(StandardCharsets.UTF_8).length);
        OutputStream os = exchange.getResponseBody();
        os.write(response.getBytes(StandardCharsets.UTF_8));
        os.close();
    }

    private class MachineCodeHandler
    implements HttpHandler {
        private MachineCodeHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"POST".equals(exchange.getRequestMethod())) {
                HttpServerManager.this.sendResponse(exchange, 405, "Method Not Allowed");
                return;
            }
            try {
                InputStream is = exchange.getRequestBody();
                Scanner scanner = new Scanner(is, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
                String requestBody = scanner.hasNext() ? scanner.next() : "";
                JsonObject json = (JsonObject)HttpServerManager.this.gson.fromJson(requestBody, JsonObject.class);
                String machineCode = json.get("machineCode").getAsString();
                String playerName = json.has("playerName") ? json.get("playerName").getAsString() : "Unknown";
                MachineCodeStorage.storeMachineCodeByPlayerName(playerName, machineCode);
                System.out.println("Received machine code: " + machineCode + " from player: " + playerName);
                if (HttpServerManager.this.minecraftServer != null) {
                    ModCheckPacket.removePendingCheck(playerName, HttpServerManager.this.minecraftServer);
                    class_3222 player = HttpServerManager.this.minecraftServer.method_3760().method_14566(playerName);
                    if (player != null) {
                        UUID playerUuid = player.method_5667();
                        String oldMachineCode = MachineCodeStorage.getMachineCode(playerUuid);
                        if (oldMachineCode != null && !oldMachineCode.equals(machineCode)) {
                            System.out.println("\u8b66\u544a\uff1a\u73a9\u5bb6 " + playerName + " \u4f7f\u7528\u4e86\u4e0d\u540c\u7684\u673a\u5668\u7801\uff01");
                            System.out.println("  \u65e7\u673a\u5668\u7801: " + oldMachineCode);
                            System.out.println("  \u65b0\u673a\u5668\u7801: " + machineCode);
                            Set<String> allMachineCodes = MachineCodeStorage.getAllMachineCodes(playerUuid);
                            allMachineCodes.add(machineCode);
                            allMachineCodes.add(oldMachineCode);
                            String reason = "\u8d26\u6237\u4f7f\u7528\u591a\u4e2a\u673a\u5668\u7801\u767b\u5f55\uff08\u53ef\u80fd\u7981\u7528\u6a21\u7ec4\u6216\u4f7f\u7528\u4e0d\u540c\u8bbe\u5907\uff09";
                            for (String code : allMachineCodes) {
                                if (HttpServerManager.this.banManager.isBanned(code)) continue;
                                HttpServerManager.this.banManager.banPlayer(code, reason);
                            }
                            HttpServerManager.this.minecraftServer.execute(() -> {
                                if (player.field_13987 != null) {
                                    player.field_13987.method_52396((class_2561)class_2561.method_43470((String)"\u68c0\u6d4b\u5230\u8d26\u6237\u4f7f\u7528\u591a\u4e2a\u673a\u5668\u7801\u767b\u5f55\uff0c\u6240\u6709\u76f8\u5173\u673a\u5668\u7801\u5df2\u88ab\u5c01\u7981"));
                                }
                            });
                        } else {
                            MachineCodeStorage.storeMachineCode(playerUuid, playerName, machineCode);
                        }
                    }
                }
                JsonObject response = new JsonObject();
                response.addProperty("success", Boolean.valueOf(true));
                response.addProperty("message", "Machine code received");
                HttpServerManager.this.sendResponse(exchange, 200, HttpServerManager.this.gson.toJson((JsonElement)response));
            }
            catch (Exception e) {
                HttpServerManager.this.sendResponse(exchange, 400, "Bad Request: " + e.getMessage());
            }
        }
    }

    private class CheckBanHandler
    implements HttpHandler {
        private CheckBanHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equals(exchange.getRequestMethod())) {
                HttpServerManager.this.sendResponse(exchange, 405, "Method Not Allowed");
                return;
            }
            try {
                String query = exchange.getRequestURI().getQuery();
                String machineCode = null;
                if (query != null) {
                    String[] params;
                    for (String param : params = query.split("&")) {
                        String[] keyValue = param.split("=");
                        if (keyValue.length != 2 || !"machineCode".equals(keyValue[0])) continue;
                        machineCode = keyValue[1];
                        break;
                    }
                }
                JsonObject response = new JsonObject();
                if (machineCode != null && HttpServerManager.this.banManager.isBanned(machineCode)) {
                    BanManager.BanEntry entry = HttpServerManager.this.banManager.getBanEntry(machineCode);
                    response.addProperty("banned", Boolean.valueOf(true));
                    response.addProperty("reason", entry != null ? entry.reason : "\u672a\u77e5\u539f\u56e0");
                    response.addProperty("timestamp", (Number)(entry != null ? entry.timestamp : 0L));
                } else {
                    response.addProperty("banned", Boolean.valueOf(false));
                }
                HttpServerManager.this.sendResponse(exchange, 200, HttpServerManager.this.gson.toJson((JsonElement)response));
            }
            catch (Exception e) {
                HttpServerManager.this.sendResponse(exchange, 400, "Bad Request: " + e.getMessage());
            }
        }
    }
}

