/*
 * Decompiled with CFR 0.152.
 */
package com.banall.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class MachineCodeStorage {
    private static final Path STORAGE_FILE = Paths.get("machine_codes.json", new String[0]);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<UUID, String> uuidToMachineCode = new ConcurrentHashMap<UUID, String>();
    private static final Map<UUID, Set<String>> uuidToAllMachineCodes = new ConcurrentHashMap<UUID, Set<String>>();
    private static final Map<String, String> playerNameToMachineCode = new ConcurrentHashMap<String, String>();
    private static final Map<UUID, String> uuidToPlayerName = new ConcurrentHashMap<UUID, String>();

    public static void loadStorage() {
        if (!Files.exists(STORAGE_FILE, new LinkOption[0])) {
            return;
        }
        try {
            String json = new String(Files.readAllBytes(STORAGE_FILE));
            StorageData data = (StorageData)gson.fromJson(json, StorageData.class);
            if (data != null) {
                if (data.playerNameToMachineCode != null) {
                    playerNameToMachineCode.putAll(data.playerNameToMachineCode);
                }
                if (data.uuidToMachineCode != null) {
                    for (Map.Entry<String, String> entry : data.uuidToMachineCode.entrySet()) {
                        try {
                            UUID uuid2 = UUID.fromString(entry.getKey());
                            uuidToMachineCode.put(uuid2, entry.getValue());
                        }
                        catch (IllegalArgumentException uuid2) {}
                    }
                }
                if (data.uuidToPlayerName != null) {
                    for (Map.Entry<String, Object> entry : data.uuidToPlayerName.entrySet()) {
                        try {
                            UUID uuid3 = UUID.fromString(entry.getKey());
                            uuidToPlayerName.put(uuid3, (String)entry.getValue());
                        }
                        catch (IllegalArgumentException uuid3) {}
                    }
                }
                if (data.uuidToAllMachineCodes != null) {
                    for (Map.Entry<String, Object> entry : data.uuidToAllMachineCodes.entrySet()) {
                        try {
                            UUID uuid = UUID.fromString(entry.getKey());
                            uuidToAllMachineCodes.put(uuid, new HashSet((Collection)entry.getValue()));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load machine code storage: " + e.getMessage());
        }
    }

    private static void saveStorage() {
        try {
            StorageData data = new StorageData();
            HashMap<String, String> uuidMap = new HashMap<String, String>();
            for (Map.Entry<UUID, String> entry : uuidToMachineCode.entrySet()) {
                uuidMap.put(entry.getKey().toString(), entry.getValue());
            }
            data.uuidToMachineCode = uuidMap;
            data.playerNameToMachineCode = new HashMap<String, String>(playerNameToMachineCode);
            HashMap<String, String> uuidToNameMap = new HashMap<String, String>();
            for (Map.Entry<UUID, String> entry : uuidToPlayerName.entrySet()) {
                uuidToNameMap.put(entry.getKey().toString(), entry.getValue());
            }
            data.uuidToPlayerName = uuidToNameMap;
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            for (Map.Entry<UUID, Set<String>> entry : uuidToAllMachineCodes.entrySet()) {
                hashMap.put(entry.getKey().toString(), new ArrayList(entry.getValue()));
            }
            data.uuidToAllMachineCodes = hashMap;
            String string = gson.toJson((Object)data);
            Files.write(STORAGE_FILE, string.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save machine code storage: " + e.getMessage());
        }
    }

    public static void storeMachineCode(UUID playerUuid, String machineCode) {
        uuidToMachineCode.put(playerUuid, machineCode);
        MachineCodeStorage.saveStorage();
    }

    public static void storeMachineCode(UUID playerUuid, String playerName, String machineCode) {
        String oldMachineCode = uuidToMachineCode.put(playerUuid, machineCode);
        uuidToAllMachineCodes.computeIfAbsent(playerUuid, k -> new HashSet()).add(machineCode);
        if (oldMachineCode != null && !oldMachineCode.equals(machineCode)) {
            uuidToAllMachineCodes.get(playerUuid).add(oldMachineCode);
        }
        playerNameToMachineCode.put(playerName.toLowerCase(), machineCode);
        uuidToPlayerName.put(playerUuid, playerName);
        MachineCodeStorage.saveStorage();
    }

    public static boolean hasDifferentMachineCode(UUID playerUuid, String newMachineCode) {
        String oldMachineCode = uuidToMachineCode.get(playerUuid);
        if (oldMachineCode == null) {
            return false;
        }
        return !oldMachineCode.equals(newMachineCode);
    }

    public static Set<String> getAllMachineCodes(UUID playerUuid) {
        return uuidToAllMachineCodes.getOrDefault(playerUuid, new HashSet());
    }

    public static void storeMachineCodeByPlayerName(String playerName, String machineCode) {
        playerNameToMachineCode.put(playerName.toLowerCase(), machineCode);
        MachineCodeStorage.saveStorage();
    }

    public static String getMachineCode(UUID playerUuid) {
        return uuidToMachineCode.get(playerUuid);
    }

    public static String getMachineCodeByPlayerName(String playerName) {
        return playerNameToMachineCode.get(playerName.toLowerCase());
    }

    public static String getPlayerName(UUID playerUuid) {
        return uuidToPlayerName.get(playerUuid);
    }

    public static void removeMachineCode(UUID playerUuid) {
        uuidToMachineCode.remove(playerUuid);
        String playerName = uuidToPlayerName.remove(playerUuid);
        if (playerName != null) {
            playerNameToMachineCode.remove(playerName.toLowerCase());
        }
        MachineCodeStorage.saveStorage();
    }

    public static void removePlayerNameMapping(String playerName) {
        playerNameToMachineCode.remove(playerName.toLowerCase());
        MachineCodeStorage.saveStorage();
    }

    public static void temporarilyRemoveMachineCode(UUID playerUuid) {
        uuidToMachineCode.remove(playerUuid);
    }

    public static void clearMachineCodeHistory(UUID playerUuid, String currentMachineCode) {
        uuidToAllMachineCodes.remove(playerUuid);
        if (currentMachineCode != null) {
            uuidToMachineCode.put(playerUuid, currentMachineCode);
            HashSet<String> newSet = new HashSet<String>();
            newSet.add(currentMachineCode);
            uuidToAllMachineCodes.put(playerUuid, newSet);
            String playerName = uuidToPlayerName.get(playerUuid);
            if (playerName != null) {
                playerNameToMachineCode.put(playerName.toLowerCase(), currentMachineCode);
            }
        }
        MachineCodeStorage.saveStorage();
    }

    public static void clearMachineCodeHistoryByPlayerName(String playerName, String currentMachineCode) {
        UUID playerUuid = null;
        for (Map.Entry<UUID, String> entry : uuidToPlayerName.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(playerName)) continue;
            playerUuid = entry.getKey();
            break;
        }
        if (playerUuid != null) {
            MachineCodeStorage.clearMachineCodeHistory(playerUuid, currentMachineCode);
        } else if (currentMachineCode != null) {
            playerNameToMachineCode.put(playerName.toLowerCase(), currentMachineCode);
            MachineCodeStorage.saveStorage();
        }
    }

    private static class StorageData {
        public Map<String, String> uuidToMachineCode;
        public Map<String, String> playerNameToMachineCode;
        public Map<String, String> uuidToPlayerName;
        public Map<String, List<String>> uuidToAllMachineCodes;

        private StorageData() {
        }
    }
}

