/*
 * Decompiled with CFR 0.152.
 */
package com.banall.server;

import com.banall.network.ModCheckPacket;
import com.banall.server.BanManager;
import com.banall.server.MachineCodeStorage;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class UdpServerManager {
    private DatagramSocket socket;
    private final BanManager banManager;
    private final Gson gson = new Gson();
    private MinecraftServer minecraftServer;
    private ExecutorService executor;
    private volatile boolean running = false;

    public UdpServerManager(BanManager banManager) {
        this.banManager = banManager;
    }

    public void setMinecraftServer(MinecraftServer server) {
        this.minecraftServer = server;
    }

    public void start(int port) {
        this.start(port, "0.0.0.0");
    }

    public void start(int port, String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            this.socket = new DatagramSocket(port, address);
            this.running = true;
            this.executor = Executors.newCachedThreadPool();
            Thread receiveThread = new Thread(this::receiveLoop, "UDP-Server-Receive");
            receiveThread.setDaemon(true);
            receiveThread.start();
            System.out.println("UDP Server started on " + host + ":" + port);
        }
        catch (IOException e) {
            System.err.println("Failed to start UDP server: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void receiveLoop() {
        byte[] buffer = new byte[4096];
        while (this.running && this.socket != null && !this.socket.isClosed()) {
            try {
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                this.socket.receive(packet);
                DatagramPacket finalPacket = packet;
                this.executor.submit(() -> this.handlePacket(finalPacket));
            }
            catch (SocketException e) {
                if (!this.running) break;
                System.err.println("UDP socket error: " + e.getMessage());
                break;
            }
            catch (IOException e) {
                if (!this.running) continue;
                System.err.println("Failed to receive UDP packet: " + e.getMessage());
            }
        }
    }

    private void handlePacket(DatagramPacket packet) {
        try {
            String jsonData = new String(packet.getData(), 0, packet.getLength(), StandardCharsets.UTF_8);
            JsonObject json = (JsonObject)this.gson.fromJson(jsonData, JsonObject.class);
            if (json.has("action") && "check".equals(json.get("action").getAsString())) {
                this.handleBanCheck(packet, json);
            } else {
                this.handleMachineCodeUpload(packet, json);
            }
        }
        catch (Exception e) {
            System.err.println("Error handling UDP packet: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void handleMachineCodeUpload(DatagramPacket packet, JsonObject json) {
        try {
            if (!json.has("machineCode") || !json.has("playerName")) {
                this.sendResponse(packet, this.createErrorResponse("Missing required fields: machineCode, playerName"));
                return;
            }
            String machineCode = json.get("machineCode").getAsString();
            String playerName = json.get("playerName").getAsString();
            MachineCodeStorage.storeMachineCodeByPlayerName(playerName, machineCode);
            System.out.println("Received machine code via UDP: " + machineCode + " from player: " + playerName);
            if (this.minecraftServer != null) {
                ModCheckPacket.removePendingCheck(playerName, this.minecraftServer);
                class_3222 player = this.minecraftServer.method_3760().method_14566(playerName);
                if (player != null) {
                    UUID playerUuid = player.method_5667();
                    String oldMachineCode = MachineCodeStorage.getMachineCode(playerUuid);
                    if (oldMachineCode != null && !oldMachineCode.equals(machineCode)) {
                        System.out.println("\u8b66\u544a\uff1a\u73a9\u5bb6 " + playerName + " \u4f7f\u7528\u4e86\u4e0d\u540c\u7684\u673a\u5668\u7801\uff01");
                        System.out.println("  \u65e7\u673a\u5668\u7801: " + oldMachineCode);
                        System.out.println("  \u65b0\u673a\u5668\u7801: " + machineCode);
                        Set<String> allMachineCodes = MachineCodeStorage.getAllMachineCodes(playerUuid);
                        allMachineCodes.add(machineCode);
                        allMachineCodes.add(oldMachineCode);
                        String reason = "\u8d26\u6237\u4f7f\u7528\u591a\u4e2a\u673a\u5668\u7801\u767b\u5f55\uff08\u53ef\u80fd\u7981\u7528\u6a21\u7ec4\u6216\u4f7f\u7528\u4e0d\u540c\u8bbe\u5907\uff09";
                        for (String code : allMachineCodes) {
                            if (this.banManager.isBanned(code)) continue;
                            this.banManager.banPlayer(code, reason);
                        }
                        this.minecraftServer.execute(() -> {
                            if (player.field_13987 != null) {
                                player.field_13987.method_52396((class_2561)class_2561.method_43470((String)"\u68c0\u6d4b\u5230\u8d26\u6237\u4f7f\u7528\u591a\u4e2a\u673a\u5668\u7801\u767b\u5f55\uff0c\u6240\u6709\u76f8\u5173\u673a\u5668\u7801\u5df2\u88ab\u5c01\u7981"));
                            }
                        });
                    } else {
                        MachineCodeStorage.storeMachineCode(playerUuid, playerName, machineCode);
                    }
                }
            }
            JsonObject response = new JsonObject();
            response.addProperty("success", Boolean.valueOf(true));
            response.addProperty("message", "Machine code received");
            this.sendResponse(packet, response);
        }
        catch (Exception e) {
            System.err.println("Error handling machine code upload: " + e.getMessage());
            e.printStackTrace();
            this.sendResponse(packet, this.createErrorResponse("Internal server error: " + e.getMessage()));
        }
    }

    private void handleBanCheck(DatagramPacket packet, JsonObject json) {
        try {
            if (!json.has("machineCode")) {
                this.sendResponse(packet, this.createErrorResponse("Missing required field: machineCode"));
                return;
            }
            String machineCode = json.get("machineCode").getAsString();
            JsonObject response = new JsonObject();
            if (this.banManager.isBanned(machineCode)) {
                BanManager.BanEntry entry = this.banManager.getBanEntry(machineCode);
                response.addProperty("banned", Boolean.valueOf(true));
                response.addProperty("reason", entry != null ? entry.reason : "\u672a\u77e5\u539f\u56e0");
                response.addProperty("timestamp", (Number)(entry != null ? entry.timestamp : 0L));
            } else {
                BanManager.BanEntry entry = this.banManager.checkPartialMatch(machineCode);
                if (entry != null) {
                    response.addProperty("banned", Boolean.valueOf(true));
                    response.addProperty("reason", entry.reason != null ? entry.reason : "\u672a\u77e5\u539f\u56e0");
                    response.addProperty("timestamp", (Number)entry.timestamp);
                } else {
                    response.addProperty("banned", Boolean.valueOf(false));
                }
            }
            this.sendResponse(packet, response);
        }
        catch (Exception e) {
            System.err.println("Error handling ban check: " + e.getMessage());
            e.printStackTrace();
            this.sendResponse(packet, this.createErrorResponse("Internal server error: " + e.getMessage()));
        }
    }

    private void sendResponse(DatagramPacket requestPacket, JsonObject response) {
        try {
            String jsonData = this.gson.toJson((JsonElement)response);
            byte[] data = jsonData.getBytes(StandardCharsets.UTF_8);
            DatagramPacket responsePacket = new DatagramPacket(data, data.length, requestPacket.getAddress(), requestPacket.getPort());
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.send(responsePacket);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to send UDP response: " + e.getMessage());
        }
    }

    private JsonObject createErrorResponse(String error) {
        JsonObject response = new JsonObject();
        response.addProperty("success", Boolean.valueOf(false));
        response.addProperty("error", error);
        return response;
    }

    public void stop() {
        this.running = false;
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
        System.out.println("UDP Server stopped");
    }
}

